DELIMITER $$
DROP PROCEDURE IF EXISTS V20200204201555__Insert_SubmitApplicationReferences $$
CREATE PROCEDURE V20200204201555__Insert_SubmitApplicationReferences()
BEGIN

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);

IF NOT EXISTS ((Select * from `msg_category` where `code` = 'SUBMIT_APPLICATION_REFERENCES')) THEN 
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SUBMIT_APPLICATION_REFERENCES');
END IF;

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SUBMIT_APPLICATION_REFERENCES');

IF NOT EXISTS ((Select * from `system_msg_event` where `code` = 'SUBMIT_APPLICATION_REFERENCES'
and `displayCode` = 'Submit Application References')) THEN 
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'SUBMIT_APPLICATION_REFERENCES', 'Submit Application References', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Submit Application References');
END IF;

SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- DL data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);

IF NOT EXISTS ((Select * from `dtprovider` where `dataProviderName` = 'SUBMIT_APPLICATION_REFERENCES_DL')) THEN 
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SUBMIT_APPLICATION_REFERENCES_DL', 'SQL');
END IF;

-- Recipient Infor data provider
SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);

IF NOT EXISTS ((Select * from `dtprovider` where `dataProviderName` = 'SUBMIT_APPLICATION_REFERENCES_RECIPIENTS')) THEN 
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SUBMIT_APPLICATION_REFERENCES_RECIPIENTS', 'SQL');
END IF;

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_REFERENCES_RECIPIENTS');

IF NOT EXISTS ((Select * from `msg_recipient_type` where `code` = 'SUBMIT_APPLICATION_REFERENCES_RECIPIENTS')) THEN 
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SUBMIT_APPLICATION_REFERENCES_RECIPIENTS');
END IF;

-- The under sql code gives for the user distribution list ,this information can be fetched
SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_REFERENCES_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SUBMIT_APPLICATION_REFERENCES_RECIPIENTS');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

-- Setting the query for the Parent distribution list
SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_REFERENCES_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T10.id AS USER_ID FROM application_references T10 WHERE T10.id IN (namedParams)",NULL);

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SUBMIT_APPLICATION_REFERENCES_RECIPIENTS');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select 
    T10.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T10.`referenceName` AS FIRST_NAME,
    T2.`firstName` AS APPLICANT_FIRST_NAME,
    T2.`middleName` AS APPLICANT_MIDDLE_NAME,
    T2.`lastName` AS APPLICANT_LAST_NAME,
    T2.`printName` APPLICANT_FULL_NAME,
    CONCAT(T3.`salutationName`,
            ' ',
            T10.`referenceName`) AS REFEREE_SALUTATION_AND_FULL_NAME,
    T10.`emailId` AS EMAIL_ID,
    T10.`contactNo` AS MOBILE_NO,
    T1.`code` AS APPLICATION_CODE,
    T9.`displayName` AS ACADEMY_NAME_LOCATION,
    T13.`referenceLetterSubmissionDeadline` AS REFERENCE_LETTER_SUBMISSION_DEADLINE,
    T14.`programNameToBePrint` AS PROGRAM_NAME_TO_BE_PRINT,
    T10.`encryptedReferenceId` AS ENCRYPTED_REFERENCE_ID
from
    application T1
        left outer join
    applicant_person T2 ON T1.applicantPersonId = T2.id
        left outer join
    application_references T10 ON T10.applicationId = T1.id
        left outer join
    salutations T3 ON T3.id = T10.salutationId        
        left outer join
    application_program T8 ON T8.applicationId = T1.id
        left outer join
    programs T14 ON T14.id = T8.programId
        left outer join
    academy_location T9 ON T9.id = T8.academyLocationId
        left outer join
    prog_batch_seat_config T11 ON T11.id = T8.progBatchSeatConfigId
        left outer join
    program_selection_process T12 ON T12.programBatchSeatConfigId = T11.id
        left outer join
    prog_slctn_process_admisn_conf T13 ON T13.programSelectionProcessId = T12.id
where
    T10.id in (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
		{
		  "id": 1,
		  "value": "salutationName",
		  "resultKey": "SALUTATION_NAME",
		  "displayCode": "",
		  "displayOrder": 1
		},
		{
		  "id": 2,
		  "value": "referenceName",
		  "resultKey": "FIRST_NAME",
		  "displayCode": "",
		  "displayOrder": 2
		},
		{
		  "id": 3,
		  "value": "firstName",
		  "resultKey": "APPLICANT_FIRST_NAME",
		  "displayCode": "",
		  "displayOrder": 3
		},
		{
		  "id": 4,
		  "value": "middleName",
		  "resultKey": "APPLICANT_MIDDLE_NAME",
		  "displayCode": "",
		  "displayOrder": 4
		},
		{
		  "id": 5,
		  "value": "lastName",
		  "resultKey": "APPLICANT_LAST_NAME",
		  "displayCode": "",
		  "displayOrder": 5
		},
		{
		  "id": 6,
		  "value": "firstName-middleName-lastName",
		  "resultKey": "APPLICANT_FULL_NAME",
		  "displayCode": "",
		  "displayOrder": 6
		},
		{
		  "id": 7,
		  "value": "salutationName-referenceName",
		  "resultKey": "REFEREE_SALUTATION_AND_FULL_NAME",
		  "displayCode": "",
		  "displayOrder": 7
		},
		{
		  "id": 8,
		  "value": "emailId",
		  "resultKey": "EMAIL_ID",
		  "displayCode": "",
		  "displayOrder": 8
		},
		{
		  "id": 9,
		  "value": "contactNo",
		  "resultKey": "MOBILE_NO",
		  "displayCode": "",
		  "displayOrder": 9
		},
		{
		  "id": 10,
		  "value": "code",
		  "resultKey": "APPLICATION_CODE",
		  "displayCode": "",
		  "displayOrder": 10
		},
		{
		  "id": 11,
		  "value": "firstName",
		  "resultKey": "PARENT_FIRSTNAME",
		  "displayCode": "",
		  "displayOrder": 11
		},
		{
		  "id": 12,
		  "value": "lastName",
		  "resultKey": "PARENT_LASTNAME",
		  "displayCode": "",
		  "displayOrder": 12
		},
		{
		  "id": 13,
		  "value": "mobileCountryCode",
		  "resultKey": "MOBILE_CODE",
		  "displayCode": "",
		  "displayOrder": 13
		},
		{
		  "id": 14,
		  "value": "displayName",
		  "resultKey": "ACADEMY_NAME_LOCATION",
		  "displayCode": "",
		  "displayOrder": 14
		},
		{
		  "id": 15,
		  "value": "referenceLetterSubmissionDeadline",
		  "resultKey": "REFERENCE_LETTER_SUBMISSION_DEADLINE",
		  "displayCode": "",
		  "displayOrder": 15
		},
		{
		  "id": 16,
		  "value": "programNameToBePrint",
		  "resultKey": "PROGRAM_NAME_TO_BE_PRINT",
		  "displayCode": "",
		  "displayOrder": 16
		},
		{
		  "id": 17,
		  "value": "encryptedReferenceId",
		  "resultKey": "ENCRYPTED_REFERENCE_ID",
		  "displayCode": "",
		  "displayOrder": 17
		}
    ]
}');

SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='SUBMIT_APPLICATION_REFERENCES');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SUBMIT_APPLICATION_REFERENCES');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SUBMIT_APPLICATION_REFERENCES_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Submit Application References Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Submit Application References Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Reference Letter request from $recipientData[&quot;APPLICANT_FULL_NAME&quot;] for $recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Dear&nbsp;<strong>$recipientData[&quot;REFEREE_SALUTATION_AND_FULL_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><strong>$recipientData[&quot;APPLICANT_FULL_NAME&quot;]</strong> is applying for admission to <strong>$recipientData[&quot;PROGRAM_NAME_TO_BE_PRINT&quot;] </strong>at the <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong>. The applicant has requested that you write a Letter of Recommendation to IIIT-B.  You may kindly upload your Letter of Recommendation in the form of a PDF file using the following link. Please note that this link is unique to this recommendation and should not be shared or forwarded. If you are a referee for other applicants, you will receive unique upload links for each applicant separately.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">
			Link for upload of reference letter: <a href="https://testing-iiitb.academiaerp.com?refId=$recipientData[&quot;ENCRYPTED_REFERENCE_ID&quot;]">Link </a></p>
				
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">The deadline for upload of the Letter of Recommendation is <strong>$recipientData[&quot;REFERENCE_LETTER_SUBMISSION_DEADLINE&quot;]</strong>. The upload link will automatically expire after this date. A timely response is important for this application to be favorably considered. Please be aware that the applicant&apos;s admission could be contingent on your timely response.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Thank you for your time and consideration.</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><br />
			Admissions Office,<br />
			$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</p>

			<p>&nbsp;</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.in/mailer/academia_email.png" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');
 
END $$
CALL V20200204201555__Insert_SubmitApplicationReferences() $$
DROP PROCEDURE IF EXISTS V20200204201555__Insert_SubmitApplicationReferences $$
DELIMITER ;